/* ***************************************/
DROP TABLE W83B08T00;
DROP TABLE W83B11T00;
DROP TABLE W83B07T00;
DROP TABLE W83B01T00;
DROP TABLE W83B02T00;
DROP TABLE W83B03T00;
DROP TABLE W83B04T00;
DROP TABLE W83B05T00;
DROP TABLE W83B06T00;
DROP TABLE W83B09T00;
DROP TABLE W83B10T00;
COMMIT;	

CREATE TABLE W83B01T00
(
       DNI_001              VARCHAR2(10),
       C_TERRIT_001         VARCHAR2(2),
       NOMBRE_001           VARCHAR2(50),
       APEL1_001            VARCHAR2(50),
       APEL2_001            VARCHAR2(50),
       EMAIL_001            VARCHAR2(100),
       F_ALTA_001           DATE,
       F_BAJA_001           DATE,
       TELEFONO_001         NUMBER(9),
       C_SINDI_001          NUMBER(3),
       ROL_001              NUMBER(1) 
)
TABLESPACE W8301E00
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       2147483645
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


COMMENT ON TABLE W83B01T00 IS 'Tabla de usuarios';
COMMENT ON COLUMN W83B01T00.DNI_001 IS 'Dni del usuario';
COMMENT ON COLUMN W83B01T00.C_TERRIT_001 IS 'Territorio del usuario';
COMMENT ON COLUMN W83B01T00.NOMBRE_001 IS 'Nombre del usuario';
COMMENT ON COLUMN W83B01T00.APEL1_001 IS 'Apellido 1 del usuario';
COMMENT ON COLUMN W83B01T00.APEL2_001 IS 'Apellido 2 del usuario';
COMMENT ON COLUMN W83B01T00.EMAIL_001 IS 'Email del usuario';
COMMENT ON COLUMN W83B01T00.F_ALTA_001 IS 'Fecha de alta del usuario';
COMMENT ON COLUMN W83B01T00.F_BAJA_001 IS 'Fecha de baja del usuario';
COMMENT ON COLUMN W83B01T00.TELEFONO_001 IS 'Telfono del usuario';
COMMENT ON COLUMN W83B01T00.C_SINDI_001 IS 'Cdigo de sindicato';
COMMENT ON COLUMN W83B01T00.ROL_001 IS 'Rol del usuario';

CREATE OR REPLACE SYNONYM W83B01S00 FOR W83B01T00;

ALTER TABLE W83B01T00 ADD (CONSTRAINT PK_W83B01T00
  PRIMARY KEY (DNI_001)
    USING INDEX 
    TABLESPACE W8302E00
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       2147483645
                PCTINCREASE      0
               ));	   

			   
/* ***************************************/
	   
CREATE TABLE W83B02T00 (
       ROL_002              NUMBER(1),
       DESC_002             VARCHAR2(30),
       DESE_002             VARCHAR2(30)
)
TABLESPACE W8301E00
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       2147483645
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE W83B02T00 IS 'Tabla de roles';

COMMENT ON COLUMN W83B02T00.ROL_002 IS 'Id del rol';
COMMENT ON COLUMN W83B02T00.DESC_002 IS 'Descripcin del rol en castellano';
COMMENT ON COLUMN W83B02T00.DESE_002 IS 'Descripcin del rol en euskera';

CREATE OR REPLACE SYNONYM W83B02S00 FOR W83B02T00;

ALTER TABLE W83B02T00 ADD (CONSTRAINT PK_W83B02T00
  PRIMARY KEY (ROL_002)
    USING INDEX 
    TABLESPACE W8302E00
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       2147483645
                PCTINCREASE      0
               ));	   
			   
/* ***************************************/

CREATE TABLE W83B07T00 (
       LOTE_007             NUMBER(5),
       DNI_007              VARCHAR2(10),
       C_SINDI_007          NUMBER(3),
       F_ENTRADA_007           DATE,
       C_TERRIT_007         VARCHAR2(2),
       F_CREACION_007       DATE,
       CORREL_007           NUMBER(3),
       N_FICHERO_IDA_007    VARCHAR2(100),
       FICHERO_IDA_007      BLOB,
       N_FICHERO_VUELTA_007 VARCHAR2(100),
       FICHERO_VUELTA_007   BLOB,
       N_PREAVISOS_007      NUMBER(3),
       N_CENAFEC_007        NUMBER(9),
       FIRMA_007            BLOB,
       TRATADO_007          VARCHAR2(1)  default 0 ,
       F_REGIS_007          DATE,
       N_REGIS_007          VARCHAR2(15),
	   N_TRABAJ_007			NUMBER(9)
)
TABLESPACE W8301E00
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       2147483645
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE W83B07T00 IS 'Tabla de lotes de preavisos';
COMMENT ON COLUMN W83B07T00.LOTE_007 IS 'Id del lote de preavisos';
COMMENT ON COLUMN W83B07T00.DNI_007 IS 'Dni del usuario';
COMMENT ON COLUMN W83B07T00.C_SINDI_007 IS 'Cdigo de sindicato';
COMMENT ON COLUMN W83B07T00.F_ENTRADA_007 IS 'Fecha de alta del lote';
COMMENT ON COLUMN W83B07T00.C_TERRIT_007 IS 'Territorio';
COMMENT ON COLUMN W83B07T00.F_CREACION_007 IS 'Fecha de creacin del lote';
COMMENT ON COLUMN W83B07T00.CORREL_007 IS 'Identificador interno';
COMMENT ON COLUMN W83B07T00.N_FICHERO_IDA_007 IS 'Nombre del fichero de ida';
COMMENT ON COLUMN W83B07T00.FICHERO_IDA_007 IS 'Fichero de ida';
COMMENT ON COLUMN W83B07T00.N_FICHERO_VUELTA_007 IS 'Nombre del fichero de vuelta';
COMMENT ON COLUMN W83B07T00.FICHERO_VUELTA_007 IS 'Fichero de vuelta';
COMMENT ON COLUMN W83B07T00.N_PREAVISOS_007 IS 'Nmero de preavisos';
COMMENT ON COLUMN W83B07T00.N_CENAFEC_007 IS 'Nmero de centros afectados';
COMMENT ON COLUMN W83B07T00.FIRMA_007 IS 'Firma';
COMMENT ON COLUMN W83B07T00.TRATADO_007 IS 'Estado del lote (0: No tratado; 1: Tratado)';
COMMENT ON COLUMN W83B07T00.F_REGIS_007 IS 'Fecha de registro de E/S';
COMMENT ON COLUMN W83B07T00.N_REGIS_007 IS 'Nmero de registro de E/S';
COMMENT ON COLUMN W83B07T00.N_TRABAJ_007 IS 'Nmero de trabajadores';

CREATE OR REPLACE SYNONYM W83B07S00 FOR W83B07T00;

ALTER TABLE W83B07T00 ADD (CONSTRAINT PK_W83B07T00
  PRIMARY KEY (LOTE_007)
    USING INDEX 
    TABLESPACE W8302E00
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       2147483645
                PCTINCREASE      0
               ));	   
			   
CREATE TABLE W83B08T00 (
       PREAVISO_008      NUMBER(9),
       CIF_008              VARCHAR2(10),
       RAZ_SOCIAL_008       VARCHAR2(100),
       DOMIC_008            VARCHAR2(200),
       C_TERRIT_008				VARCHAR2(2),
       MUNIC_008            VARCHAR2(3),
       CODPOS_008           VARCHAR2(5),
       TELEFONO_008         VARCHAR2(15),
       EMAIL_008            VARCHAR2(100),
       FAX_008              VARCHAR2(15),
       CNAE_008             VARCHAR(4),
       F_INICIO_008         DATE,
       C_CONV_008           NUMBER(4),
       LOTE_008             NUMBER(5),
       S_PARCIAL_008        VARCHAR2(1),
       GLOBAL_008           VARCHAR2(1),
       N_CENAFEC_008        NUMBER(6,0),
       ADMONEMP_008         VARCHAR2(1),
       F_REGIS_008          DATE,
       N_REGIS_008          VARCHAR2(15),
       IDENT_008            VARCHAR2(15),
       C_SINDI_PROM_008     NUMBER(3),
       OBSERV_008           VARCHAR2(255),
	   PROV_008         	VARCHAR2(2),
	   N_PREAVISO_008       NUMBER(6) NULL,
       ANO_PREAVISO_008     NUMBER(4) NULL,
	   TIPO_008				VARCHAR2(1) DEFAULT 'I',
	   ESTADO_008           VARCHAR2(1) default 0,
	   TIPO_IDEN_008		NUMBER(1,0),
	   TH_SS_008			VARCHAR2(2),
	   N_SS_008				VARCHAR2(7),
	   CTRL_SS_008			VARCHAR2(2),
	   N_TRABAJ_008			NUMBER(6)
)
TABLESPACE W8301E00
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       2147483645
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE W83B08T00 IS 'Tabla de preavisos pendientes';
COMMENT ON COLUMN W83B08T00.PREAVISO_008 IS 'Id del preaviso';
COMMENT ON COLUMN W83B08T00.CIF_008 IS 'CIF de la empresa';
COMMENT ON COLUMN W83B08T00.RAZ_SOCIAL_008 IS 'Razn social';
COMMENT ON COLUMN W83B08T00.DOMIC_008 IS 'Domicilio del centro de trabajo';
COMMENT ON COLUMN W83B08T00.PROV_008 IS 'Provincia del centro de trabajo';
COMMENT ON COLUMN W83B08T00.MUNIC_008 IS 'Municipio del centro';
COMMENT ON COLUMN W83B08T00.CODPOS_008 IS 'Cdigo postal del centro';
COMMENT ON COLUMN W83B08T00.TELEFONO_008 IS 'Telfono del centro';
COMMENT ON COLUMN W83B08T00.EMAIL_008 IS 'Email del centro';
COMMENT ON COLUMN W83B08T00.FAX_008 IS 'Fax del centro';
COMMENT ON COLUMN W83B08T00.CNAE_008 IS 'CNAE del centro';
COMMENT ON COLUMN W83B08T00.F_INICIO_008 IS 'Fecha de inicio';
COMMENT ON COLUMN W83B08T00.C_CONV_008 IS 'Codigo de convenio';
COMMENT ON COLUMN W83B08T00.LOTE_008 IS 'Id del lote de preavisos';
COMMENT ON COLUMN W83B08T00.ESTADO_008 IS 'Estado del preaviso (0: Sin tratar; 1 consolidado; 2 descartado)';
COMMENT ON COLUMN W83B08T00.N_CENAFEC_008 IS 'N de centro afectados';
COMMENT ON COLUMN W83B08T00.S_PARCIAL_008 IS 'Eleccin Parcial';
COMMENT ON COLUMN W83B08T00.GLOBAL_008 IS 'Preaviso global';
COMMENT ON COLUMN W83B08T00.ADMONEMP_008 IS 'Administracin o empresa';
COMMENT ON COLUMN W83B08T00.F_REGIS_008 IS 'Fecha de registro';
COMMENT ON COLUMN W83B08T00.N_REGIS_008 IS 'Nmero de registro';
COMMENT ON COLUMN W83B08T00.IDENT_008 IS 'Identificador';
COMMENT ON COLUMN W83B08T00.C_SINDI_PROM_008 IS 'Sindicato promotor';
COMMENT ON COLUMN W83B08T00.OBSERV_008 IS 'Observaciones';
COMMENT ON COLUMN W83B08T00.N_PREAVISO_008 IS 'Nmero del preaviso';
COMMENT ON COLUMN W83B08T00.ANO_PREAVISO_008 IS 'Ao del preaviso';
COMMENT ON COLUMN W83B08T00.C_TERRIT_008 IS 'Territorio del preaviso';
COMMENT ON COLUMN W83B08T00.TIPO_008 IS 'I si es un preaviso del lote de ida; V si es un preaviso del lote de vuelta';
COMMENT ON COLUMN W83B08T00.TIPO_IDEN_008 IS 'Tipo identificacin fiscal de la empresa';
COMMENT ON COLUMN W83B08T00.TH_SS_008 IS 'Territorio seguridad social';
COMMENT ON COLUMN W83B08T00.N_SS_008 IS 'Nmero de seguridad social';
COMMENT ON COLUMN W83B08T00.CTRL_SS_008 IS 'Dgito de control del cdigo de seguridad social';
COMMENT ON COLUMN W83B08T00.N_TRABAJ_008 IS 'N de trabajadores';
	   
CREATE OR REPLACE SYNONYM W83B08S00 FOR W83B08T00;

ALTER TABLE W83B08T00 ADD (CONSTRAINT PK_W83B08T00
  PRIMARY KEY (PREAVISO_008)
    USING INDEX 
    TABLESPACE W8302E00
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       2147483645
                PCTINCREASE      0
               ));	   
  
   
CREATE TABLE W83B11T00 (
       NOTIFICACION_011     INTEGER,
       DNI_011              VARCHAR2(10),
       C_SINDI_011          NUMBER(3),
       LOTE_011             NUMBER(5)
)
TABLESPACE W8301E00
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            MINEXTENTS       1
            MAXEXTENTS       2147483645
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;

COMMENT ON TABLE W83B11T00 IS 'Tabla de notificaciones';
COMMENT ON COLUMN W83B11T00.NOTIFICACION_011 IS 'Id de la notificacin';
COMMENT ON COLUMN W83B11T00.DNI_011 IS 'Dni del usuario';
COMMENT ON COLUMN W83B11T00.LOTE_011 IS 'Id del lote de preavisos';
COMMENT ON COLUMN W83B11T00.C_SINDI_011 IS 'Cdigo de sindicato';
   
CREATE OR REPLACE SYNONYM W83B11S00 FOR W83B11T00;

ALTER TABLE W83B11T00 ADD (CONSTRAINT PK_W83B11T00
  PRIMARY KEY (NOTIFICACION_011)
    USING INDEX 
    TABLESPACE W8302E00
    PCTFREE    10
    INITRANS   2
    MAXTRANS   255
    STORAGE    (
                INITIAL          64K
                MINEXTENTS       1
                MAXEXTENTS       2147483645
                PCTINCREASE      0
               ));
ALTER TABLE W83B01T00 ADD (
  CONSTRAINT FK_W83B01T00_01 FOREIGN KEY (C_SINDI_001) 
    REFERENCES W83B19T00 (C_SINDI_019));
						
ALTER TABLE W83B01T00 ADD (
  CONSTRAINT FK_W83B01T00_02 FOREIGN KEY (ROL_001) 
    REFERENCES W83B02T00 (ROL_002));
	
ALTER TABLE W83B07T00 ADD (
  CONSTRAINT FK_W83B07T00_01 FOREIGN KEY (DNI_007) 
    REFERENCES W83B01T00 (DNI_001));
	
ALTER TABLE W83B08T00 ADD (
  CONSTRAINT FK_W83B08T00_01 FOREIGN KEY (LOTE_008) 
    REFERENCES W83B07T00 (LOTE_007));
	
ALTER TABLE W83B11T00 ADD (
  CONSTRAINT FK_W83B11T00_01 FOREIGN KEY (DNI_011) 
    REFERENCES W83B01T00 (DNI_001));
					
ALTER TABLE W83B11T00 ADD (
  CONSTRAINT FK_W83B11T00_02 FOREIGN KEY (LOTE_011) 
    REFERENCES W83B07T00 (LOTE_007));

ALTER TABLE W83B11T00 ADD (
  CONSTRAINT FK_W83B11T00_03 FOREIGN KEY (C_SINDI_011) 
    REFERENCES W83B19T00 (C_SINDI_019));	

ALTER TABLE W83B01T00
ADD CONSTRAINT CK_W83B01T00_01 CHECK (DNI_001 IS NOT NULL);

ALTER TABLE W83B01T00
ADD CONSTRAINT CK_W83B01T00_02 CHECK (C_TERRIT_001 IS NOT NULL);

ALTER TABLE W83B02T00
ADD CONSTRAINT CK_W83B02T00_01 CHECK (ROL_002 IS NOT NULL);

ALTER TABLE W83B07T00
ADD CONSTRAINT CK_W83B07T00_01 CHECK (LOTE_007 IS NOT NULL);

ALTER TABLE W83B08T00
ADD CONSTRAINT CK_W83B08T00_01 CHECK (PREAVISO_008 IS NOT NULL);

ALTER TABLE W83B11T00
ADD CONSTRAINT CK_W83B11T00_01 CHECK (NOTIFICACION_011 IS NOT NULL);

ALTER TABLE W83B.W83B37T00
ADD (TIPO_PREAV_037 NUMBER(1) DEFAULT 0 NOT NULL);

COMMENT ON COLUMN W83B.W83B37T00.TIPO_PREAV_037 IS 'Tipo de preaviso: 0=presencial, 1=por lote';

ALTER TABLE W83B08T00
  MODIFY (IDENT_008  VARCHAR2(50) );
  
ALTER TABLE w83b08t00
	ADD ncen_008 number(3);
	
ALTER TABLE w83b42t00 ADD FECHA_CIERRE_01_042 DATE;

ALTER TABLE w83b42t00 ADD FECHA_CIERRE_20_042 DATE;

ALTER TABLE w83b42t00 ADD FECHA_CIERRE_48_042 DATE;

